 /******************************************************************************		
*                                                                                   	
*       Copyright (C) 2006 Freescale Semiconductor, Inc.                            	
*       All Rights Reserved								              				
*														              					
* Filename:       init_ICG.c               											
*														              					
* Description:	     	       						
*																						
* Notes:        																		
*  ***********************************************************************  			
*  *  THIS CODE IS ONLY INTENDED AS AN EXAMPLE OF CODE FOR THE           *  	 		
*  *  FREESCALE CW COMPILER AND HAS ONLY BEEN GIVEN A MIMIMUM            *  	 		
*  *  LEVEL OF TEST. IT IS PROVIDED 'AS SEEN' WITH NO GUARANTEES         *  	 		
*  *  AND NO PROMISE OF SUPPORT.                                         *  	 		
*  ***********************************************************************  	 		
*																						
* Freescale reserves the right to make changes without further notice to any			
* product herein to improve reliability, function, or design. Freescale does	 		
* not assume any  liability arising  out  of the  application or use of any 	 		
* product,  circuit, or software described herein;  neither  does it convey 	 		
* any license under its patent rights  nor the  rights of others.  Freescale	 		
* products are not designed, intended,  or authorized for use as components 	 		
* in  systems  intended  for  surgical  implant  into  the  body, or  other 	 		
* applications intended to support life, or  for any  other application  in 	 		
* which the failure of the Freescale product  could create a situation where	 		
* personal injury or death may occur. Should Buyer purchase or use Freescale	 		
* products for any such intended  or unauthorized  application, Buyer shall 	 		
* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,	 		
* affiliates,  and distributors harmless against all claims costs, damages, 	  		
* and expenses, and reasonable  attorney  fees arising  out of, directly or 	 		
* indirectly,  any claim of personal injury  or death  associated with such 	 		
* unintended or unauthorized use, even if such claim alleges that  Freescale	 		
* was negligent regarding the  design  or manufacture of the part. Freescale	 		
* and the Freescale logo* are registered trademarks of Freescale Ltd.       	 		
******************************************************************************/	

#include <hidef.h> /* for EnableInterrupts macro */
#include <MC9S08GB60.h> /* include peripheral declarations */

/***************************************************************************************
 *                                                                                     *
 *  FUNCTION - init_ICG                                                                *
 *                                                                                     *
 *  DESCRIPTION - Setup registers                                                      *
 *              - Selects FBE mode on ICG (lowest power/highest accuracy)              *
 *                                                                                     *
 *  RETURNS     - None                                                                 *
 *                                                                                     *
 *  NOTES:                                                                             *
 *                                                                                     *
 * Configuration FLL Bypassed; external clock reference:                               *
 *                                                                                     *
 * f(EXT) = 32 kHz                                                                     *                                                                  *
 * P      = N/A (low freuqency range)                                                  *
 * R=2                                                                                 *
 *                                                                                     *
 * ficgout = f(EXT)/R                                                                  *
 *         = 32k/2                                                                     *
 *         = 16kHz                                                                     *
 **************************************************************************************/
    

void init_ICG (void) 
{

  /***********************ICG CONTROL REGISTER 1 (ICGC1)********************************
  
   
         BIT7  |   BIT6  |   BIT5   |  BIT4    |   BIT3   |  BIT2   |  BIT1   |  BIT0 
        ------------------------------------------------------------------------------
       | HGO   |   RANGE |   REFS   |         CLKS        | OSCSTEN |  LOCD   |    0  |
        ------------------------------------------------------------------------------
       |   0   |    0    |    1     |    1     |     0    |    1    |    0    |    0  |
        ------------------------------------------------------------------------------
        
        HGO=0;    OSCILLATOR CONFIGURED FOR LOW POWER OERATION
        RANGE=0;  OSCILLATOR CONFIGURED FOR LOW FREQUENCY (P=64)
        REFS=1;   OSCILLATOR USING CRYSTAL OR RESONATOR
        CLKS=10;  FBE MODE SELECTED
        OSCTEN=1; OSCILLATOR ENABLED WHEN ICG IS OFF MODE
        LOCD=0;   LOSS OF CLOCK DETECTION ENABLED
        
    ***********************************************************************************/
  
  ICGC1 = 0b00110100;
  
    /***********************ICG CONTROL REGISTER 2 (ICGC2)********************************
  
   
         BIT7  |   BIT6  |   BIT5   |  BIT4    |   BIT3   |  BIT2   |  BIT1   |  BIT0 
        ------------------------------------------------------------------------------
       | LOLRE |              MFD              |  LOCRE   |            RFD            |
        ------------------------------------------------------------------------------
       |   0   |    0    |    0     |    0     |     0    |    0    |    0    |    0  |
        ------------------------------------------------------------------------------
        
        LOLRE=0;    GENERATE AN INTERRUPT REQUEST ON LOSS OF LOCK
        MFD=0:0:0;  MULT FACTOR = 4
        LOCRE=0;    GENERATE AN INTERRUPT ON LOSS OF CLOCK
        RFD=0:0:0;  DIVISION FACTOR=1
        
    ***********************************************************************************/
  
  ICGC2 = 0b00000000;
  
   for (;ICGS1_LOCK;);   /* wait until FLL is locked */
}